# Развёртывание на Ubuntu сервере

## 1. Требования

- Node.js 18+ 
- npm или yarn
- MySQL (уже установлен с базой movielab)

## 2. Установка Node.js (если не установлен)

```bash
curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -
sudo apt-get install -y nodejs
```

## 3. Скачивание проекта

Скачайте ZIP архив проекта с Replit и распакуйте в папку, например `/var/www/support-panel`:

```bash
sudo mkdir -p /var/www/support-panel
cd /var/www/support-panel
# Распакуйте архив сюда
```

## 4. Установка зависимостей

```bash
cd /var/www/support-panel
npm install
```

## 5. Создание файла конфигурации

Создайте файл `.env` с вашими данными:

```bash
cat > .env << 'EOF'
NODE_ENV=production
PORT=5000

# MySQL
MYSQL_HOST=localhost
MYSQL_PORT=3306
MYSQL_USER=root
MYSQL_PASSWORD=dE5vbtjQ42Nf
MYSQL_DATABASE=movielab

# Telegram Bot
TELEGRAM_BOT_TOKEN=5946069569:AAFZF6pbQiGhVidsmJk-VH7YTtShtxuH_N8

# Безопасность - ОБЯЗАТЕЛЬНО ИЗМЕНИТЕ!
SESSION_SECRET=ваш-секретный-ключ-минимум-32-символа
ADMIN_USERNAME=admin
ADMIN_PASSWORD=ваш_новый_пароль
EOF
```

**ВАЖНО:** Измените `SESSION_SECRET` и `ADMIN_PASSWORD` на свои значения!

## 6. Сборка проекта

```bash
npm run build
```

## 7. Запуск

### Вариант A: Простой запуск (для тестирования)

```bash
npm start
```

### Вариант B: Запуск через PM2 (рекомендуется для production)

```bash
# Установка PM2
sudo npm install -g pm2

# Запуск приложения
pm2 start npm --name "support-panel" -- start

# Автозапуск при перезагрузке сервера
pm2 startup
pm2 save
```

## 8. Настройка Nginx (опционально, для доступа по домену)

Если хотите разместить в папке `/var/www/html` и использовать nginx:

```bash
sudo nano /etc/nginx/sites-available/support-panel
```

Добавьте:

```nginx
server {
    listen 80;
    server_name ваш_домен.ru;  # или IP сервера

    location / {
        proxy_pass http://127.0.0.1:5000;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_cache_bypass $http_upgrade;
    }
}
```

Активируйте конфигурацию:

```bash
sudo ln -s /etc/nginx/sites-available/support-panel /etc/nginx/sites-enabled/
sudo nginx -t
sudo systemctl reload nginx
```

## 9. База данных

Панель адаптирована под вашу существующую базу данных `movielab` и использует таблицы:
- `requests` - обращения пользователей
- `messages` - история сообщений  
- `admins` - администраторы

Никаких дополнительных таблиц создавать не нужно!

## 10. Доступ к панели

После запуска панель будет доступна по адресу:
- http://ваш_ip:5000 (напрямую)
- http://ваш_домен.ru (через nginx)

**Логин:** admin  
**Пароль:** тот, что указали в ADMIN_PASSWORD

---

## Полезные команды PM2

```bash
pm2 status              # Статус приложений
pm2 logs support-panel  # Просмотр логов
pm2 restart support-panel # Перезапуск
pm2 stop support-panel    # Остановка
```
