process.env.NTBA_FIX_319 = 1;
process.env["NTBA_FIX_350"] = 1;
const fs = require("fs");
const TelegramBot = require("node-telegram-bot-api");
const TOKEN = `5946069569:AAFZF6pbQiGhVidsmJk-VH7YTtShtxuH_N8`;

const bot = new TelegramBot(TOKEN, {
  polling: {
    interval: 0,
    autoStart: true,
    params: {
      timeout: 10,
    },
  },
});
// const BEARER = `eyJhbGciOiJIUzI1NiJ9.eyJhdWQiOiI5Y2QyNjFlYTdjM2NhNjMwMDIxMWM3ODA0NTRjNGJhOCIsInN1YiI6IjYzNjZlYzQ0MTY4NGY3MDA3Zjc4NGQ1MCIsInNjb3BlcyI6WyJhcGlfcmVhZCJdLCJ2ZXJzaW9uIjoxfQ.GbIAR0FFOgaptfbgpA0USz3Zt3UsIblGW5wvRLYJ-Lw`;

// Кнопка запросить фильм

const {
  nameSearch,
  checkAdmin,
  newCooperation,
  getCategories,
  keyGenerator,
  checkSubscription,
  addMessage,
  getFAQ,
  newSupportRequest,
  getPersonFilms,
  getQuestions,
  getAnswer,
  sendAnswer,
  getRequestRow,
  getMenuKeyboard,
  getUnsolvedRequests,
  tookRequest,
  getLuckyShot,
  dbRequest,
  clearMessages,
  newUser,
  banUser,
  checkBlackList,
  analytics,
  takeQuestion,
  getFilmByLetters,
  newFilmRequest,
  getUserRequestsHistory,
  idSearch,
} = require("./functions");

let filmObject = {};
let currentPosition = {};
let pendingRequest = {};
let pendingAnswer = {};
let luckyShotObject = {};
const maxFileSize = 5242880;

const started = () => {
  bot.sendMessage(-1001844046661, `Bot was started`, {
    parse_mode: "HTML",
  });
};

started();

const errorReport = (id, username, message) => {
  bot.sendMessage(-1001844046661, `<b>Ошибка у пользователя ${id} (@${username})\n\n</b>${message}`, {
    parse_mode: "HTML",
  });

  bot
    .sendMessage(id, `Произошла ошибка, пожалуйста, давайте вернёмся в главное меню`, {
      reply_markup: {
        inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
      },
      parse_mode: "HTML",
    })
    .then(function (sendedMessage) {
      addMessage(id, sendedMessage["message_id"], "", "", username, "", id);
    });
};

const adminID = 5692422878;

bot.on(`text`, async (msg) => {
  const id = msg?.from?.id;
  const chatID = msg?.chat?.id;
  const firstName = msg?.from?.first_name.replace(/[`'"]/g, "");
  const lastName = msg?.from?.last_name ? msg.from.last_name.replace(/[`'"]/g, "") : " ";
  const username = msg?.from?.username ? msg.from.username : " ";
  const messageID = msg?.message_id;
  const userMessage = msg?.text.replace(/[`'"]/g, "");
  const timestamp = msg?.date;
  const subscribed = await checkSubscription(id, bot);

  if (chatID > 0) {
    clearMessages(id, bot);

    if (userMessage === `/start`) {
      const ifAdmin = await checkAdmin(id);
      const keyboard = await getMenuKeyboard(id);
      const ifUserNew = await newUser(id, firstName, lastName, username, timestamp);

      if (keyboard.status === 200) {
        bot
          .sendMessage(id, `Привет, ${firstName}\n\nЧем я могу помочь?`, {
            reply_markup: {
              inline_keyboard: keyboard.message,
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      } else {
        console.log(`Error`);
        errorReport(id, username, `Can't get menu keyboard`);
      }
    } else if (currentPosition[id] === `film search`) {
      const search = await nameSearch(userMessage.trim());
      analytics(`user side`, id, firstName, username, timestamp, `Name search`);

      if (search.status === 200) {
        if (data.message.length > 0) {
          currentPosition[id] = `film searching`;

          for (let q = 0; q < data.message.length; q++) {
            const { message, posterURL, link } = data.message[q];

            bot
              .sendPhoto(id, `${posterURL}?0`, {
                caption: message.slice(0, 924),
                parse_mode: `HTML`,
                reply_markup: {
                  inline_keyboard: [[{ text: "Посмотреть", url: link }]],
                },
              })
              .then()
              .catch((err) => {
                if (err) {
                  console.log(err);
                  bot.sendMessage(id, message, {
                    parse_mode: `HTML`,
                    reply_markup: {
                      inline_keyboard: [[{ text: "Посмотреть", url: link }]],
                    },
                  });
                }
              });
          }
        } else {
          bot.sendMessage(id, `Я не нашёл ничего, что подходит под ваш запрос. Введите новый запрос пожалуйста`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
            },
            parse_mode: "HTML",
          });
        }
      } else {
        errorReport(id, username, `Can't make a film search`);
      }
    } else if (currentPosition[id] === `ask for request`) {
      if (userMessage.length < 1000) {
        pendingRequest[id].text = userMessage;

        if (
          userMessage.toUpperCase().includes("SELECT") ||
          userMessage.toUpperCase().includes("TRUNCATE") ||
          userMessage.toUpperCase().includes("DELETE") ||
          userMessage.toUpperCase().includes("UPDATE") ||
          userMessage.toUpperCase().includes("SHOW") ||
          userMessage.toUpperCase().includes("INSERT")
        ) {
          pendingRequest[id].text = `ВНИМАНИЕ. ПОПЫТКА НЕСАНКЦИОНИРОВАННОГО ДОСТУПА К БАЗЕ ДАННЫХ`;

          bot
            .sendMessage(id, `Вы хотите добавить видео или фото к запросу?`, {
              reply_markup: {
                inline_keyboard: [
                  [{ text: "Да", callback_data: "add media" }],
                  [{ text: "Нет", callback_data: "request done" }],
                ],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        } else {
          pendingRequest[id].text = userMessage;
          bot
            .sendMessage(id, `Вы хотите добавить видео или фото к запросу?`, {
              reply_markup: {
                inline_keyboard: [
                  [{ text: "Да", callback_data: "add media" }],
                  [{ text: "Нет", callback_data: "request done" }],
                ],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        }
      } else {
        bot
          .sendMessage(id, `Это слишком большое сообщение. Пожалуйста, сократите его и отправьте снова`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      }
    } else if (currentPosition[id] === `search by name`) {
      const films = await nameSearch(userMessage);

      const sendKeyboard = () => {
        bot
          .sendMessage(
            id,
            `Это фильмы и сериалы, которые я нашёл по вашему запросу. Начните смотреть один из них или введите новый запрос`,
            {
              reply_markup: {
                inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
              },
              parse_mode: "HTML",
            }
          )
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      };

      if (films.status === 200) {
        if (films.message.length > 0) {
          let sent = 0;

          for (let q = 0; q < films.message.length; q++) {
            const film = films.message[q];
            const filmMessage = `<b>${film.name}</b> (${film.year}, ${film.type})\n<b>Жанр:</b> ${film.genres}\n\n<b>Год:</b> ${film.year}\n<b>Рейтинг:</b> ${film.rating}`;

            bot
              .sendPhoto(id, film.poster, {
                caption: filmMessage.slice(0, 924),
                reply_markup: {
                  inline_keyboard: [
                    [{ text: "Смотреть", url: `${film.link}` }],
                    [{ text: "Главное меню", callback_data: "main menu" }],
                  ],
                },
                parse_mode: "HTML",
              })
              .then(function (sendedMessage) {
                sent++;
                if (sent === films.message.length) {
                  sendKeyboard();
                }
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              })
              .catch((err) => {
                console.log(err);

                bot
                  .sendPhoto(id, `./movieLabLogo.png`, {
                    caption: filmMessage.slice(0, 924),
                    reply_markup: {
                      inline_keyboard: [
                        [{ text: "Смотреть", url: `${film.link}` }],
                        [{ text: "Главное меню", callback_data: "main menu" }],
                      ],
                    },
                    parse_mode: "HTML",
                  })
                  .then(function (sendedMessage) {
                    sent++;
                    if (sent === data.message.results.length) {
                      sendKeyboard();
                    }
                    addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                  });
              });
          }
        } else {
          bot
            .sendMessage(
              id,
              `К сожалению, я не нашёл фильм или сериал с таким названием. Попробуйте ввести другое название`,
              {
                reply_markup: {
                  inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
                },
                parse_mode: "HTML",
              }
            )
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        }
      } else {
        errorReport(id, username, `Can't get films by name`);
      }
    } else if (currentPosition[id] === `cooperation`) {
      analytics(`user side`, id, firstName, username, timestamp, `Cooperation request sent`);
      if (userMessage.length < 2000) {
        currentPosition[id] = `main menu`;
        newCooperation(id, firstName, lastName, username, userMessage, bot).then((data) => {
          if (data.status === 200) {
            bot
              .sendMessage(id, `Спасибо! Мы скоро свяжемся с вами`, {
                reply_markup: {
                  inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
                },
                parse_mode: "HTML",
              })
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              });
          } else {
            errorReport(id, username, `Can't send a cooperation offer`);
          }
        });
      } else {
        bot
          .sendMessage(id, `Сообщение слишком большое, пожалуйста сократите его до 2000 символов`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      }
    } else if (currentPosition[id] && currentPosition[id].includes(`answer to `)) {
      analytics(`user side`, id, firstName, username, timestamp, `Text answer`);

      if (userMessage.length < 2000) {
        const questionID = currentPosition[id].replace(`answer to `, ``);
        pendingAnswer[id] = userMessage;

        bot
          .sendMessage(
            id,
            `Ваш ответ:\n\n<b>${userMessage}</b>\n\nЕсли вы хотите изменить ответ, отправьте его ниже. Отправить этот ответ?`,
            {
              reply_markup: {
                inline_keyboard: [[{ text: "Отправить", callback_data: `send answer ${questionID}` }]],
              },
              reply_to_message_id: messageID,
              parse_mode: "HTML",
            }
          )
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      } else {
        bot.sendMessage(id, `Пожалуйста, сократите ответ`, {
          parse_mode: "HTML",
        });
      }
    } else if (currentPosition[id] === `new film request`) {
      currentPosition[id] = `film received`;
      const result = await newFilmRequest(id, firstName, username, userMessage, timestamp);
      const settings = JSON.parse(fs.readFileSync("./settings.json", "utf-8"));

      if (result?.status === 200) {
        const sentBy = username.length > 1 ? `${firstName} (@${username})` : firstName;

        // bot.sendMessage(
        //   settings?.groupID,
        //   `<b>Новый запрос на добавление фильма</b>\n\n<b>Запрос от:</b> ${sentBy}\n\n<b>Фильм:</b> ${userMessage}`,
        //   {
        //     parse_mode: "HTML",
        //   }
        // );

        bot
          .sendMessage(
            id,
            `Спасибо за рекомендацию! Пока мы занимаемся добавлением новых фильмов, вы можете посмотреть нашу текущую библиотеку`,
            {
              reply_markup: {
                inline_keyboard: [
                  [{ text: "Найти фильм", callback_data: "search categories" }],
                  [{ text: "Главное меню", callback_data: "main menu" }],
                ],
              },
              parse_mode: "HTML",
            }
          )
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      } else {
        errorReport(id, username, `Can't add new film request`);
      }
    } else if (msg?.via_bot?.id > 0) {
      currentPosition[id] = `inline mode`;
      const selectedFilm = msg?.reply_markup?.inline_keyboard[0][0]?.url;
      analytics(`user side`, id, firstName, username, timestamp, `Film selected ${selectedFilm}`);

      if (selectedFilm) {
        const filmID = selectedFilm.replace("https://mlab.vip/movies/", "");

        const filmCard = await idSearch(filmID);

        if (filmCard?.status === 200) {
          const { name, year, genres, rating, description, poster, link, kinopoisk_id } = filmCard.message;
          luckyShotObject[id] = kinopoisk_id;
          const filmMessage = `<b>${name}</b> (${year})\n<b>Рейтинг:</b> ${rating}\n<b>Жанр:</b> ${genres}`;

          bot
            .sendPhoto(id, poster, {
              caption: filmMessage.slice(0, 924),
              reply_markup: {
                inline_keyboard: [
                  [{ text: "Смотреть", url: `${selectedFilm}` }],
                  [{ text: "Найти другой фильм", switch_inline_query_current_chat: "" }],
                  [{ text: "Главное меню", callback_data: "main menu" }],
                ],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            })
            .catch((err) => {
              console.log(err);
              errorReport(id, username, `Can't get poster`);

              bot
                .sendPhoto(id, `./movieLabLogo.png`, {
                  caption: filmMessage.slice(0, 924),
                  reply_markup: {
                    inline_keyboard: [
                      [{ text: "Смотреть", url: `${link}` }],
                      [{ text: "Главное меню", callback_data: "main menu" }],
                    ],
                  },
                  parse_mode: "HTML",
                })
                .then(function (sendedMessage) {
                  addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                });
            });
        } else {
          errorReport(id, username, `Can't get film by id`);
          console.log(filmCard);

          bot
            .sendMessage(
              id,
              `Отличный выбор! Вы можете начать просмотр фильма, нажав на кнопку "Смотреть" или я могу подобрать вам другие варианты`,
              {
                reply_markup: {
                  inline_keyboard: [
                    [{ text: "Перейти на сайт", url: selectedFilm }],
                    [{ text: "Главное меню", callback_data: "main menu" }],
                  ],
                },
                parse_mode: "HTML",
              }
            )
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        }
      } else {
        bot
          .sendMessage(id, `Вы не выбрали фильм. Хотите поискать ещё или порекомендовать вам фильм?`, {
            reply_markup: {
              inline_keyboard: [
                [{ text: "Найти другой фильм", switch_inline_query_current_chat: "" }],
                [{ text: "Получить рекомендацию", callback_data: `lucky shot` }],
                [{ text: "Главное меню", callback_data: "main menu" }],
              ],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      }
    } else {
      currentPosition[id] = `main menu`;

      bot
        .sendMessage(id, `Вам не нужно отправлять сообщение сейчас. Что вы хотите?`, {
          reply_markup: {
            inline_keyboard: [
              [{ text: "Найти фильм", switch_inline_query_current_chat: "" }],
              [{ text: `Задать вопрос`, callback_data: `support service` }],
              [{ text: "Главное меню", callback_data: "main menu" }],
            ],
          },
          parse_mode: "HTML",
        })
        .then(function (sendedMessage) {
          addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
        });
    }
  } else {
  }
});

bot.on("callback_query", async (callback_query) => {
  const id = callback_query?.from?.id;
  const chatID = callback_query?.message?.chat.id;
  const messageID = callback_query?.message?.message_id;
  const query = callback_query?.data;
  const firstName = callback_query?.from?.first_name.replace(/[`'"]/g, "");
  const lastName = callback_query?.from?.last_name ? callback_query.from.last_name.replace(/[`'"]/g, "") : "";
  const username = callback_query?.from?.username ? callback_query.from.username : "";
  const timestamp = callback_query?.message?.date;
  const subscribed = await checkSubscription(id, bot);
  const settings = JSON.parse(fs.readFileSync("./settings.json", "utf-8"));

  if (query === `main menu`) {
    clearMessages(id, bot);
    currentPosition[id] = query;
    const keyboard = await getMenuKeyboard(id);

    if (keyboard.status === 200) {
      bot
        .sendMessage(id, `Мы в главном меню, ${firstName}. Чем я могу вам помочь?`, {
          reply_markup: {
            inline_keyboard: keyboard.message,
          },
          parse_mode: "HTML",
        })
        .then(function (sendedMessage) {
          addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
        });
    } else {
      errorReport(id, username, `Can't get menu keyboard`);
    }
  } else if (chatID > 0) {
    clearMessages(id, bot);

    if (subscribed.message === true) {
      if (query === `support service`) {
        analytics(`user side`, id, firstName, username, timestamp, `Support service enter`);

        currentPosition[id] = query;
        const keyboard = await getCategories();

        if (keyboard.status === 200) {
          if (keyboard.message.length > 0) {
            bot
              .sendMessage(id, `${firstName}, пожалуйста уточните категорию вашего вопроса`, {
                reply_markup: {
                  inline_keyboard: keyboard.message,
                },
                parse_mode: "HTML",
              })
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              });
          } else {
            bot
              .sendMessage(id, `FAQ в процессе разработки. Пожалуйста, попробуйте позже`, {
                reply_markup: {
                  inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
                },
                parse_mode: "HTML",
              })
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              });
          }
        } else {
          errorReport(id, username, `Can't get categories for user`);
        }
      } else if (query === `ask for request`) {
        const ifBanned = await checkBlackList(id);

        if (ifBanned.status === 200) {
          if (ifBanned.message === false) {
            pendingRequest[id] = {
              id,
              firstName,
              username,
              text: false,
              media: false,
              timestamp: false,
              uniqueID: false,
            };

            currentPosition[id] = query;

            bot
              .sendMessage(id, `Пожалуйста, напишите ваш вопрос`, {
                reply_markup: {
                  inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
                },
                parse_mode: "HTML",
              })
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              });
          } else {
            currentPosition[id] = `main menu`;

            bot
              .sendMessage(id, `Служба поддержки сейчас недоступна. Пожалуйста, попробуйте позже`, {
                reply_markup: {
                  inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
                },
                parse_mode: "HTML",
              })
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              });
          }
        } else {
          errorReport(id, username, `Can't get blacklist`);
        }
      } else if (query === `request done`) {
        analytics(`user side`, id, firstName, username, timestamp, `Request done`);
        currentPosition[id] = query;
        pendingRequest[id].timesamp = timestamp;
        pendingRequest[id].uniqueID = keyGenerator();

        const messageHeader =
          username.length > 1
            ? `<b>Новый запрос от ${firstName} (@${username})!</b>`
            : `<b>Новый запрос от ${firstName}!</b>`;

        newSupportRequest({
          uniqueID: pendingRequest[id].uniqueID,
          id,
          firstName,
          username,
          request: pendingRequest[id].text,
          timestamp,
          media: pendingRequest[id].media,
        }).then((data) => {
          if (data.status !== 200) {
            errorReport(id, username, `Can't add request`);
          }
        });

        if (pendingRequest[id].media === false || pendingRequest[id].media.length === 0) {
          bot.sendMessage(settings.groupID, `${messageHeader}\n\n${pendingRequest[id].text}`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Обработать", callback_data: `response ${pendingRequest[id].uniqueID}` }]],
            },
            parse_mode: "HTML",
          });

          bot.sendMessage(settings.intersectionGroupID, `${messageHeader}\n\n${pendingRequest[id].text}`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Обработать", callback_data: `response ${pendingRequest[id].uniqueID}` }]],
            },
            parse_mode: "HTML",
          });
        } else {
          bot
            .sendMediaGroup(settings.groupID, pendingRequest[id].media, {
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              bot.sendMessage(settings.groupID, `${messageHeader}\n\n${pendingRequest[id].text}`, {
                reply_markup: {
                  inline_keyboard: [[{ text: "Обработать", callback_data: `response ${pendingRequest[id].uniqueID}` }]],
                },
                reply_to_message_id: sendedMessage[0]["message_id"],
                parse_mode: "HTML",
              });

              bot.sendMessage(settings.intersectionGroupID, `${messageHeader}\n\n${pendingRequest[id].text}`, {
                reply_markup: {
                  inline_keyboard: [[{ text: "Обработать", callback_data: `response ${pendingRequest[id].uniqueID}` }]],
                },
                reply_to_message_id: sendedMessage[0]["message_id"],
                parse_mode: "HTML",
              });
            })
            .catch((err) => {
              errorReport(id, username, `Can't send new request`);
            });
        }

        bot
          .sendMessage(id, `Ваш запрос был успешно отправлен, скоро вам поступит ответ в этом чате`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      } else if (query === `I subscribed`) {
        currentPosition[id] = query;
        const keyboard = await getMenuKeyboard(id);

        if (subscribed?.status === 200) {
          if (subscribed.message === false) {
            bot
              .sendMessage(
                id,
                `Вы не подписаны. Пожалуйста, подпишитесь на наш <a href="https://t.me/Movie_Lab">канал</a> и после этого вы сможете использовать бот`,
                {
                  reply_markup: {
                    inline_keyboard: [
                      [{ text: "Подписаться", url: "https://t.me/Movie_Lab" }],
                      [{ text: "Подписка оформлена", callback_data: "I subscribed" }],
                      [{ text: "Главное меню", callback_data: "main menu" }],
                    ],
                  },
                  parse_mode: "HTML",
                }
              )
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              });
          } else {
            bot
              .sendMessage(id, `Спасибо за подписку!\n\nНапомните пожалуйста, чем я могу вам помочь?`, {
                reply_markup: {
                  inline_keyboard: keyboard.message,
                },
                parse_mode: "HTML",
              })
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              });
          }
        } else {
          bot
            .sendMessage(id, `Произошла ошибка. Давайте попробуем снова?`, {
              reply_markup: {
                inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
          errorReport(id, username, `Can't get a subscription`);
        }
      } else if (query === `lucky shot`) {
        analytics(`user side`, id, firstName, username, timestamp, `Lucky shot`);
        const currentLuckyShot = luckyShotObject[id] ? luckyShotObject[id] : "";

        currentPosition[id] = query;
        const film = await getLuckyShot(currentLuckyShot);

        if (film.status === 200) {
          if (film.message?.name) {
            const { name, year, genres, rating, duration, description, poster, link, kinopoisk_id } = film.message;
            luckyShotObject[id] = kinopoisk_id;
            const filmMessage = `<b>${name}</b> (${year})\n<b>Рейтинг:</b> ${rating}\n<b>Жанр:</b> ${genres}`;

            bot
              .sendPhoto(id, poster, {
                caption: filmMessage.slice(0, 924),
                reply_markup: {
                  inline_keyboard: [
                    [{ text: "Смотреть", url: `${link}` }],
                    [{ text: "Получить другой фильм", callback_data: `lucky shot` }],
                    [{ text: "Главное меню", callback_data: "main menu" }],
                  ],
                },
                parse_mode: "HTML",
              })
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              })
              .catch((err) => {
                console.log(err);
                errorReport(id, username, `Can't get poster`);

                bot
                  .sendPhoto(id, `./movieLabLogo.png`, {
                    caption: filmMessage.slice(0, 924),
                    reply_markup: {
                      inline_keyboard: [
                        [{ text: "Смотреть", url: `${link}` }],
                        [{ text: "Получить другой фильм", callback_data: `lucky shot` }],
                        [{ text: "Главное меню", callback_data: "main menu" }],
                      ],
                    },
                    parse_mode: "HTML",
                  })
                  .then(function (sendedMessage) {
                    addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                  });
              });
          } else {
            bot
              .sendMessage(id, `Пожалуйста, повторите запрос чуть позже`, {
                reply_markup: {
                  inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
                },
                parse_mode: "HTML",
              })
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              });
          }
        } else {
          errorReport(id, username, `Can't get random film`);
        }
      } else if (query.includes(`category,`)) {
        currentPosition[id] = query;
        const querySplited = query.split(",");
        const categoryID = querySplited[1];
        const questions = await getQuestions(categoryID);
        analytics(`user side`, id, firstName, username, timestamp, `Enter category ${categoryID}`);

        if (questions.status === 200) {
          bot
            .sendMessage(id, `Пожалуйста, выберите вопрос, который вас интересует`, {
              reply_markup: {
                inline_keyboard: questions.message,
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        } else {
          errorReport(id, username, `Can't get questions in category ${categoryID}`);
        }
      } else if (query.includes(`getan`)) {
        currentPosition[id] = query;
        const questionID = query.replace(`getan `, ``);
        const data = await getAnswer(questionID, id);
        analytics(`user side`, id, firstName, username, timestamp, `Enter question ${questionID}`);

        if (data.status === 200) {
          const { question, answer, categoryID, media, mediaType } = data.message;

          if (media == "0") {
            bot
              .sendMessage(id, `<b>${question}</b>\n\n${answer}`, {
                reply_markup: {
                  inline_keyboard: [
                    [{ text: "Назад", callback_data: `category,${categoryID}` }],
                    [{ text: "Главное меню", callback_data: "main menu" }],
                  ],
                },
                parse_mode: "HTML",
              })
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              });
          } else {
            if (mediaType === `photo`) {
              bot
                .sendPhoto(id, media, {
                  caption: `<b>${question}</b>\n\n${answer}`,
                  reply_markup: {
                    inline_keyboard: [
                      [{ text: "Назад", callback_data: `category,${categoryID}` }],
                      [{ text: "Главное меню", callback_data: "main menu" }],
                    ],
                  },
                  parse_mode: "HTML",
                })
                .then(function (sendedMessage) {
                  addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                });
            } else if (mediaType === `video`) {
              bot
                .sendVideo(id, media, {
                  caption: `<b>${question}</b>\n\n${answer}`,
                  reply_markup: {
                    inline_keyboard: [
                      [{ text: "Назад", callback_data: `category,${categoryID}` }],
                      [{ text: "Главное меню", callback_data: "main menu" }],
                    ],
                  },
                  parse_mode: "HTML",
                })
                .then(function (sendedMessage) {
                  addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                });
            } else {
              bot
                .sendMessage(id, `<b>${question}</b>\n\n${answer}`, {
                  reply_markup: {
                    inline_keyboard: [
                      [{ text: "Назад", callback_data: `category,${categoryID}` }],
                      [{ text: "Главное меню", callback_data: "main menu" }],
                    ],
                  },
                  parse_mode: "HTML",
                })
                .then(function (sendedMessage) {
                  addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                });
            }
          }
        } else {
          errorReport(id, username, `Can't get answer`);
        }
      } else if (query === `add media`) {
        currentPosition[id] = query;

        bot
          .sendMessage(id, `Пожалуйста, отправьте мне фото или видео, я прикреплю это к запросу`, {
            reply_markup: {
              inline_keyboard: [
                [{ text: "Отправить без файла", callback_data: "request done" }],
                [{ text: "Главное меню", callback_data: "main menu" }],
              ],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      } else if (query === `search categories`) {
        currentPosition[id] = query;

        bot
          .sendMessage(
            id,
            `Для того чтобы начать поиск, выберите по какому критерию мы ищем фильм. Затем вам нужно будет набрать поисковый запрос ниже и вы увидите результаты в удобном списке\n\nТакже вы можете попросить нас добавить новый фильм, нажав на соответствующую кнопку ниже`,
            {
              reply_markup: {
                inline_keyboard: [
                  [{ text: "Поиск по названию", switch_inline_query_current_chat: "" }],
                  [{ text: "Запрос на добавление фильма", callback_data: "new film request" }],
                  [{ text: "Главное меню", callback_data: "main menu" }],
                ],
              },
              parse_mode: "HTML",
            }
          )
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      } else if (query === `contact us`) {
        currentPosition[id] = query;

        bot
          .sendMessage(id, `Что именно вас интересует?`, {
            reply_markup: {
              inline_keyboard: [
                [{ text: "Служба поддержки", callback_data: "support service" }],
                [{ text: "Сотрудничество", callback_data: "cooperation" }],
                [{ text: "Главное меню", callback_data: "main menu" }],
              ],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      } else if (query === `cooperation`) {
        analytics(`user side`, id, firstName, username, timestamp, `Enter cooperation`);
        currentPosition[id] = query;

        bot
          .sendMessage(id, `Пожалуйста, опишите ваше предложение. Мы напишем вам ответ на этот Telegram аккаунт`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      } else if (query.includes(`send answer `)) {
        analytics(`user side`, id, firstName, username, timestamp, `Support service answer done`);
        const requestID = query.replace(`send answer `, ``);
        const result = await sendAnswer(requestID, pendingAnswer[id], id, username, timestamp);

        if (result.status === 200) {
          bot
            .sendMessage(id, `Ответ отправлен`, {
              reply_markup: {
                inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });

          bot
            .sendMessage(
              result.message.user_id,
              `<b>Вам пришёл ответ от службы поддержки</b>\n\nВаш вопрос: ${result.message.request}\n\nОтвет: ${pendingAnswer[id]}`,
              {
                reply_markup: {
                  inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
                },
                parse_mode: "HTML",
              }
            )
            .then(function (sendedMessage) {
              addMessage(
                result.message.user_id,
                sendedMessage["message_id"],
                firstName,
                lastName,
                username,
                timestamp,
                result.message.user_id
              );
            });
        } else {
          errorReport(id, username, `Can't send answer`);
        }
      } else if (query.includes(`create response `)) {
        const requestID = query.replace(`create response `, ``);
        const requestRow = await getRequestRow(requestID);
        const questionTook = await takeQuestion(id, timestamp, requestID);
        currentPosition[id] = `answer to ${requestID}`;

        if (requestRow.status === 200) {
          bot
            .sendMessage(id, `Пожалуйста, введите ответ на запрос\n\nТекст запроса: ${requestRow.message.request}`, {
              reply_markup: {
                inline_keyboard: [[{ text: "Заблокировать пользователя", callback_data: "ban user " + requestID }]],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        } else {
          errorReport(id, username, `Can't get request row for admin`);
        }
      } else if (query.includes(`ban user `)) {
        const requestID = query.replace(`ban user `, ``);
        currentPosition[id] = query;

        bot
          .sendMessage(id, `Вы точно хотите заблокировать этого пользователя?`, {
            reply_markup: {
              inline_keyboard: [
                [{ text: "Да", callback_data: "finally ban " + requestID }],
                [{ text: "Ответить на запрос", callback_data: "create response " + requestID }],
              ],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      } else if (query.includes(`finally ban `)) {
        analytics(`user side`, id, firstName, username, timestamp, `User banned`);
        currentPosition[id] = query;
        const requestID = query.replace(`finally ban `, ``);
        const ban = await banUser(requestID, `${id}`, username, `${timestamp}`);

        if (ban.status === 200) {
          bot
            .sendMessage(id, `Пользователь был успешно заблокирован`, {
              reply_markup: {
                inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        } else {
          errorReport(id, username, `Can't ban user`);
        }
      } else if (query === `unsolved requests`) {
        currentPosition[id] = query;
        const requests = await getUnsolvedRequests(id);

        if (requests.status === 200) {
          if (requests.message.length > 0) {
            const { user_first_name, user_username, request, uniqueID } = requests.message[0];
            const requestBy = user_username.length > 0 ? `${user_first_name} (@${user_username})` : user_first_name;

            bot
              .sendMessage(
                id,
                `${firstName}, что вы хотите сделать с запросом от ${requestBy}?\n\nТекст запроса: '${request}'`,
                {
                  reply_markup: {
                    inline_keyboard: [
                      [{ text: "Ответить", callback_data: "create response " + uniqueID }],
                      [{ text: "Заблокировать пользователя", callback_data: "ban user " + uniqueID }],
                    ],
                  },
                  parse_mode: "HTML",
                }
              )
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              });
          } else {
            bot
              .sendMessage(id, `У вас нет необработанных запросов`, {
                reply_markup: {
                  inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
                },
                parse_mode: "HTML",
              })
              .then(function (sendedMessage) {
                addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
              });
          }
        } else {
          errorReport(id, username, `Can't get unsolved requests`);
        }
      } else if (query.includes(`get history of `)) {
        currentPosition[id] = query;
        const selectedID = query.replace("get history of ", ``);
        const requestsHistory = await getUserRequestsHistory(selectedID);

        if (requestsHistory?.status === 200) {
          bot
            .sendMessage(id, requestsHistory?.message, {
              reply_markup: {
                inline_keyboard: [
                  [{ text: "Ответить", callback_data: "create response " + selectedID }],
                  [{ text: "Заблокировать пользователя", callback_data: "ban user " + selectedID }],
                ],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        } else {
          errorReport(id, username, `Can't get user requests history`);
        }
      } else if (query === `new film request`) {
        currentPosition[id] = query;

        bot
          .sendMessage(id, `Пожалуйста, отправьте название фильма, который вы хотите добавить`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      }
    } else {
      analytics(`user side`, id, firstName, username, timestamp, `Unsubscribed request`);
      bot
        .sendMessage(
          id,
          `Для того чтобы пользоваться ботом, вы должны подписаться на наш <a href="https://t.me/Movie_Lab">канал</a>\n\nТам вы сможете следить за всеми новинками`,
          {
            reply_markup: {
              inline_keyboard: [
                [{ text: "Подписаться", url: "https://t.me/Movie_Lab" }],
                [{ text: "Подписка оформлена", callback_data: "I subscribed" }],
              ],
            },
            parse_mode: "HTML",
          }
        )
        .then(function (sendedMessage) {
          addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
        });
    }
  } else {
    if (query.includes(`response `)) {
      const answerTo = query.replace(`response `, ``);
      const unsolvedRequests = await getUnsolvedRequests(id);

      if (unsolvedRequests.status === 200 && unsolvedRequests.message.length === 0) {
        currentPosition[id] = `asked to action`;
        pendingAnswer[id] = ``;
        const requestRow = await getRequestRow(answerTo);
        const newRequestTook = await tookRequest(id);

        if (newRequestTook.status !== 200) {
          errorReport(id, username, `Can't took request from user ${answerTo}`);
        }

        if (requestRow.status === 200) {
          bot.editMessageReplyMarkup(
            { inline_keyboard: [] },
            {
              chat_id: chatID,
              message_id: messageID,
            }
          );

          bot
            .sendMessage(
              id,
              `${firstName}, что вы хотите сделать с запросом?\n\nТекст запроса: '${requestRow.message.request}'`,
              {
                reply_markup: {
                  inline_keyboard: [
                    [{ text: "Ответить", callback_data: "create response " + requestRow.message.uniqueID }],
                    [
                      {
                        text: "Посмотреть историю запросов",
                        callback_data: `get history of ${requestRow.message.uniqueID}`,
                      },
                    ],
                    [{ text: "Заблокировать пользователя", callback_data: "ban user " + requestRow.message.uniqueID }],
                  ],
                },
                parse_mode: "HTML",
              }
            )
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        } else {
          errorReport(id, username, `Can't get request row`);
        }
      } else {
        bot.answerCallbackQuery(callback_query.id, {
          text: `У вас уже есть нерешённый запрос, пожалуйста, сначала ответьте на него в диалоге с ботом`,
          show_alert: true,
          cache_time: 5,
        });
      }
    }
  }
});

bot.on("inline_query", async (inline_query) => {
  const id = inline_query?.from?.id;
  const firstName = inline_query?.from?.firstName;
  const username = inline_query?.from.username ? inline_query.from.username : "";
  const query = inline_query?.query ? inline_query?.query.replace(/[^a-zа-яA-ZА-Я0-9 ]+/g, "").trim() : "";
  const response = await getFilmByLetters(query, inline_query.id);
  currentPosition[id] = `inline mode`;

  if (response.status === 200) {
    bot.answerInlineQuery(inline_query.id, response.message, {
      cache_time: 5,
    });
  } else {
    errorReport(id, username, `Error searching by letters`);
  }
});

bot.on("photo", (msg) => {
  const id = msg?.from?.id;
  const chatID = msg?.chat?.id;
  const firstName = msg?.from?.first_name.replace(/[`'"]/g, "");
  const lastName = msg?.from?.last_name ? msg?.from?.last_name.replace(/[`'"]/g, "") : " ";
  const username = msg?.from?.username ? msg?.from?.username : " ";
  const messageID = msg?.message_id;
  const userMessage = msg?.text;
  const timestamp = msg?.date;
  const fileID = msg?.photo[msg?.photo.length - 1]?.file_id;
  const uniqueID = msg?.photo[msg?.photo.length - 1]?.file_unique_id;
  const fileSize = msg?.photo[msg?.photo.length - 1]?.file_size;

  if (chatID) {
    clearMessages(id, bot);

    if (fileSize < maxFileSize) {
      if (currentPosition[id] === `add media`) {
        if (pendingRequest[id].media === false) {
          pendingRequest[id].media = [];
        }

        if (pendingRequest[id].media.length < 5) {
          bot.downloadFile(fileID, "./files").then((data) => {
            fs.rename(`./${data}`, `./files/${uniqueID}`, (err, data) => {
              if (err) {
                bot
                  .sendMessage(
                    id,
                    `Извините, но я не могу приложить этот файл к обращению. Попробуйте приложить другой файл или отправить запрос без него`,
                    {
                      reply_markup: {
                        inline_keyboard: [
                          [{ text: "Отправить запрос", callback_data: "request done" }],
                          [{ text: "Главное меню", callback_data: "main menu" }],
                        ],
                      },
                      parse_mode: "HTML",
                    }
                  )
                  .then(function (sendedMessage) {
                    addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                  });
              } else {
                pendingRequest[id].media.push({ type: `photo`, media: `./files/${uniqueID}` });

                bot
                  .sendMessage(id, `Файл добавлен к обращению. Вы можете приложить ещё файл или отправить запрос`, {
                    reply_markup: {
                      inline_keyboard: [
                        [{ text: "Отправить", callback_data: "request done" }],
                        [{ text: "Главное меню", callback_data: "main menu" }],
                      ],
                    },
                    parse_mode: "HTML",
                  })
                  .then(function (sendedMessage) {
                    addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                  });
              }
            });
          });
        } else {
          bot
            .sendMessage(id, `Вы прикрепили максимальное количество файлов. Давайте отправим запрос?`, {
              reply_markup: {
                inline_keyboard: [
                  [{ text: "Отправить", callback_data: "request done" }],
                  [{ text: "Главное меню", callback_data: "main menu" }],
                ],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        }
      } else {
        currentPosition[id] = `main menu`;

        bot
          .sendMessage(id, `Вам не нужно отправлять сообщение сейчас. Что вы хотите?`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      }
    } else {
      bot
        .sendMessage(id, `Файл слишком велик, пожалуйста, сожмите его и отправьте снова или выберите другой файл`, {
          reply_markup: {
            inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
          },
          parse_mode: "HTML",
        })
        .then(function (sendedMessage) {
          addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
        });
    }
  }
});

bot.on("document", (msg) => {
  const id = msg?.from?.id;
  const chatID = msg?.chat?.id;
  const firstName = msg?.from?.first_name.replace(/[`'"]/g, "");
  const lastName = msg?.from?.last_name ? msg?.from?.last_name.replace(/[`'"]/g, "") : " ";
  const username = msg?.from?.username ? msg?.from?.username : " ";
  const timestamp = msg?.date;
  const fileID = msg?.document?.file_id;
  const uniqueID = msg?.document?.file_unique_id;
  const fileSize = msg?.document?.file_size;

  if (chatID > 0) {
    clearMessages(id, bot);

    if (fileSize < maxFileSize) {
      if (currentPosition[id] === `add media`) {
        if (pendingRequest[id].media === false) {
          pendingRequest[id].media = [];
        }

        if (pendingRequest[id].media.length < 5) {
          bot.downloadFile(fileID, "./files").then((data) => {
            fs.rename(`./${data}`, `./files/${uniqueID}`, (err, data) => {
              if (err) {
                bot
                  .sendMessage(
                    id,
                    `Извините, но я не могу приложить этот файл к обращению. Попробуйте приложить другой файл или отправить запрос без него`,
                    {
                      reply_markup: {
                        inline_keyboard: [
                          [{ text: "Отправить запрос", callback_data: "request done" }],
                          [{ text: "Главное меню", callback_data: "main menu" }],
                        ],
                      },
                      parse_mode: "HTML",
                    }
                  )
                  .then(function (sendedMessage) {
                    addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                  });
              } else {
                pendingRequest[id].media.push({ type: `video`, media: `./files/${uniqueID}` });

                bot
                  .sendMessage(id, `Файл добавлен к обращению. Вы можете приложить ещё файл или отправить запрос`, {
                    reply_markup: {
                      inline_keyboard: [
                        [{ text: "Отправить", callback_data: "request done" }],
                        [{ text: "Главное меню", callback_data: "main menu" }],
                      ],
                    },
                    parse_mode: "HTML",
                  })
                  .then(function (sendedMessage) {
                    addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                  });
              }
            });
          });
        } else {
          bot
            .sendMessage(id, `Вы прикрепили максимальное количество файлов. Давайте отправим запрос?`, {
              reply_markup: {
                inline_keyboard: [
                  [{ text: "Отправить", callback_data: "request done" }],
                  [{ text: "Главное меню", callback_data: "main menu" }],
                ],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        }
      } else {
        currentPosition[id] = `main menu`;

        bot
          .sendMessage(id, `Вам не нужно отправлять сообщение сейчас. Что вы хотите?`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      }
    } else {
      bot
        .sendMessage(id, `Файл слишком велик, пожалуйста, сожмите его и отправьте снова или выберите другой файл`, {
          reply_markup: {
            inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
          },
          parse_mode: "HTML",
        })
        .then(function (sendedMessage) {
          addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
        });
    }
  }
});

bot.on("animation", (msg) => {
  const id = msg?.from?.id;
  const chatID = msg?.chat?.id;
  const firstName = msg?.from?.first_name.replace(/[`'"]/g, "");
  const lastName = msg?.from?.last_name ? msg.from.last_name.replace(/[`'"]/g, "") : " ";
  const username = msg?.from?.username ? msg.from.username : " ";
  const timestamp = msg?.date;
  const fileID = msg?.document?.file_id;
  const uniqueID = msg?.document?.file_unique_id;
  const fileSize = msg?.animation?.file_size ? msg?.animation?.file_size : 9999999999;

  if (chatID > 0) {
    clearMessages(id, bot);
    if (fileSize < maxFileSize) {
      if (currentPosition[id] === `add media`) {
        if (pendingRequest[id].media === false) {
          pendingRequest[id].media = [];
        }

        if (pendingRequest[id].media.length < 5) {
          bot.downloadFile(fileID, "./files").then((data) => {
            fs.rename(`./${data}`, `./files/${uniqueID}`, (err, data) => {
              if (err) {
                bot
                  .sendMessage(
                    id,
                    `Извините, но я не могу приложить этот файл к обращению. Попробуйте приложить другой файл или отправить запрос без него`,
                    {
                      reply_markup: {
                        inline_keyboard: [
                          [{ text: "Отправить запрос", callback_data: "request done" }],
                          [{ text: "Главное меню", callback_data: "main menu" }],
                        ],
                      },
                      parse_mode: "HTML",
                    }
                  )
                  .then(function (sendedMessage) {
                    addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                  });
              } else {
                pendingRequest[id].media.push({ type: `video`, media: `./files/${uniqueID}` });

                bot
                  .sendMessage(id, `Файл добавлен к обращению. Вы можете приложить ещё файл или отправить запрос`, {
                    reply_markup: {
                      inline_keyboard: [
                        [{ text: "Отправить", callback_data: "request done" }],
                        [{ text: "Главное меню", callback_data: "main menu" }],
                      ],
                    },
                    parse_mode: "HTML",
                  })
                  .then(function (sendedMessage) {
                    addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                  });
              }
            });
          });
        } else {
          bot
            .sendMessage(id, `Вы прикрепили максимальное количество файлов. Давайте отправим запрос?`, {
              reply_markup: {
                inline_keyboard: [
                  [{ text: "Отправить", callback_data: "request done" }],
                  [{ text: "Главное меню", callback_data: "main menu" }],
                ],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        }
      } else {
        currentPosition[id] = `main menu`;

        bot
          .sendMessage(id, `Вам не нужно отправлять сообщение сейчас. Что вы хотите?`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      }
    } else {
      bot
        .sendMessage(id, `Файл слишком велик, пожалуйста, сожмите его и отправьте снова или выберите другой файл`, {
          reply_markup: {
            inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
          },
          parse_mode: "HTML",
        })
        .then(function (sendedMessage) {
          addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
        });
    }
  }
});

bot.on("video", (msg) => {
  const id = msg?.from?.id;
  const chatID = msg?.chat?.id;
  const firstName = msg?.from?.first_name.replace(/[`'"]/g, "");
  const lastName = msg?.from?.last_name ? msg.from.last_name.replace(/[`'"]/g, "") : " ";
  const username = msg?.from?.username ? msg.from.username : " ";
  const timestamp = msg?.date;
  const fileID = msg?.video?.file_id;
  const uniqueID = msg?.video?.file_unique_id;
  const fileSize = msg?.video?.file_size;

  if (chatID > 0) {
    clearMessages(id, bot);

    if (fileSize < maxFileSize) {
      if (currentPosition[id] === `add media`) {
        if (pendingRequest[id].media === false) {
          pendingRequest[id].media = [];
        }

        if (pendingRequest[id].media.length < 5) {
          bot.downloadFile(fileID, "./files").then((data) => {
            fs.rename(`./${data}`, `./files/${uniqueID}`, (err, data) => {
              if (err) {
                bot
                  .sendMessage(
                    id,
                    `Извините, но я не могу приложить этот файл к обращению. Попробуйте приложить другой файл или отправить запрос без него`,
                    {
                      reply_markup: {
                        inline_keyboard: [
                          [{ text: "Отправить запрос", callback_data: "request done" }],
                          [{ text: "Главное меню", callback_data: "main menu" }],
                        ],
                      },
                      parse_mode: "HTML",
                    }
                  )
                  .then(function (sendedMessage) {
                    addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                  });
              } else {
                pendingRequest[id].media.push({ type: `video`, media: `./files/${uniqueID}` });

                bot
                  .sendMessage(id, `Файл добавлен к обращению. Вы можете приложить ещё файл или отправить запрос`, {
                    reply_markup: {
                      inline_keyboard: [
                        [{ text: "Отправить", callback_data: "request done" }],
                        [{ text: "Главное меню", callback_data: "main menu" }],
                      ],
                    },
                    parse_mode: "HTML",
                  })
                  .then(function (sendedMessage) {
                    addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
                  });
              }
            });
          });
        } else {
          bot
            .sendMessage(id, `Вы прикрепили максимальное количество файлов. Давайте отправим запрос?`, {
              reply_markup: {
                inline_keyboard: [
                  [{ text: "Отправить", callback_data: "request done" }],
                  [{ text: "Главное меню", callback_data: "main menu" }],
                ],
              },
              parse_mode: "HTML",
            })
            .then(function (sendedMessage) {
              addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
            });
        }
      } else {
        currentPosition[id] = `main menu`;

        bot
          .sendMessage(id, `Вам не нужно отправлять сообщение сейчас. Что вы хотите?`, {
            reply_markup: {
              inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
            },
            parse_mode: "HTML",
          })
          .then(function (sendedMessage) {
            addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
          });
      }
    } else {
      bot
        .sendMessage(id, `Файл слишком велик, пожалуйста, сожмите его и отправьте снова или выберите другой файл`, {
          reply_markup: {
            inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
          },
          parse_mode: "HTML",
        })
        .then(function (sendedMessage) {
          addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
        });
    }
  }
});

bot.on(`polling_error`, (err) => {
  // console.log(err);

  bot
    .sendMessage(err?.from?.id, `Произошла ошибка. Пожалуйста, давайте попробуем снова`, {
      reply_markup: {
        inline_keyboard: [[{ text: "Главное меню", callback_data: "main menu" }]],
      },
      parse_mode: "HTML",
    })
    .then(function (sendedMessage) {
      addMessage(id, sendedMessage["message_id"], firstName, lastName, username, timestamp, id);
    });
});
