import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";
import { Search, X } from "lucide-react";
import type { RequestStatus } from "@shared/schema";

interface StatusFilterProps {
  status: RequestStatus | "all";
  onStatusChange: (status: RequestStatus | "all") => void;
  search: string;
  onSearchChange: (search: string) => void;
}

export function StatusFilter({
  status,
  onStatusChange,
  search,
  onSearchChange,
}: StatusFilterProps) {
  return (
    <div className="flex flex-wrap items-center gap-4">
      <div className="relative flex-1 min-w-[200px] max-w-[300px]">
        <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-4 w-4 text-muted-foreground" />
        <Input
          placeholder="Поиск по имени или username..."
          value={search}
          onChange={(e) => onSearchChange(e.target.value)}
          className="pl-9 pr-9"
          data-testid="input-search"
        />
        {search && (
          <Button
            variant="ghost"
            size="icon"
            className="absolute right-1 top-1/2 -translate-y-1/2 h-7 w-7"
            onClick={() => onSearchChange("")}
          >
            <X className="h-3 w-3" />
          </Button>
        )}
      </div>

      <Select value={status} onValueChange={(v) => onStatusChange(v as RequestStatus | "all")}>
        <SelectTrigger className="w-[180px]" data-testid="select-status">
          <SelectValue placeholder="Статус" />
        </SelectTrigger>
        <SelectContent>
          <SelectItem value="all">Все статусы</SelectItem>
          <SelectItem value="new">Новые</SelectItem>
          <SelectItem value="in_progress">В работе</SelectItem>
          <SelectItem value="resolved">Решённые</SelectItem>
        </SelectContent>
      </Select>
    </div>
  );
}
