import { useQuery } from "@tanstack/react-query";
import { Link } from "wouter";
import { StatsCard } from "@/components/stats-card";
import { RequestTable } from "@/components/request-table";
import { Skeleton } from "@/components/ui/skeleton";
import { Button } from "@/components/ui/button";
import {
  MessageSquare,
  Clock,
  CheckCircle,
  Users,
  ArrowRight,
  AlertCircle,
} from "lucide-react";
import type { DashboardStats, SupportRequest } from "@shared/schema";

export default function DashboardPage() {
  const { data: stats, isLoading: statsLoading } = useQuery<DashboardStats>({
    queryKey: ["/api/stats"],
  });

  const { data: recentRequests, isLoading: requestsLoading } = useQuery<SupportRequest[]>({
    queryKey: ["/api/requests", { limit: 5, status: "new" }],
  });

  return (
    <div className="space-y-8">
      <div>
        <h1 className="text-2xl font-semibold">Дашборд</h1>
        <p className="text-muted-foreground">
          Обзор обращений и статистика
        </p>
      </div>

      <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
        {statsLoading ? (
          <>
            {[...Array(4)].map((_, i) => (
              <Skeleton key={i} className="h-32" />
            ))}
          </>
        ) : stats ? (
          <>
            <StatsCard
              title="Всего обращений"
              value={stats.totalRequests}
              icon={MessageSquare}
              description="За всё время"
            />
            <StatsCard
              title="Новых"
              value={stats.newRequests}
              icon={AlertCircle}
              description="Ожидают ответа"
            />
            <StatsCard
              title="В работе"
              value={stats.inProgressRequests}
              icon={Clock}
              description="Обрабатываются"
            />
            <StatsCard
              title="Решено"
              value={stats.resolvedRequests}
              icon={CheckCircle}
              description="Закрытые обращения"
            />
          </>
        ) : null}
      </div>

      <div className="space-y-4">
        <div className="flex items-center justify-between gap-4">
          <div>
            <h2 className="text-lg font-semibold">Новые обращения</h2>
            <p className="text-sm text-muted-foreground">
              Последние обращения, требующие внимания
            </p>
          </div>
          <Button variant="outline" asChild>
            <Link href="/requests" data-testid="link-all-requests">
              Все обращения
              <ArrowRight className="h-4 w-4 ml-2" />
            </Link>
          </Button>
        </div>

        <RequestTable
          requests={recentRequests || []}
          isLoading={requestsLoading}
          selectedIds={[]}
          onSelectionChange={() => {}}
          onBulkReply={() => {}}
        />
      </div>
    </div>
  );
}
