# Design Guidelines: Telegram Bot Support Admin Panel

## Design Approach

**Selected System:** Material Design with modern, clean execution inspired by Linear's efficiency and Notion's information hierarchy.

**Rationale:** This is a utility-focused admin dashboard requiring high information density, quick scanability, and efficient data manipulation. Material Design provides robust patterns for data tables, cards, and forms while maintaining clarity.

**Key Principles:**
- **Data-first layout:** Maximize information visibility without clutter
- **Quick scanning:** Clear visual hierarchy for status, timestamps, and user info
- **Efficient workflows:** Minimize clicks for common actions (reply, mark resolved)
- **Responsive data density:** Adapt information display for different screen sizes

## Typography

**Font Families:**
- Primary: Inter (via Google Fonts CDN) - excellent readability for data-heavy interfaces
- Monospace: JetBrains Mono - for IDs, timestamps, technical data

**Hierarchy:**
- Page titles: text-2xl font-semibold (32px)
- Section headers: text-lg font-semibold (18px)
- Card titles: text-base font-medium (16px)
- Body text: text-sm (14px)
- Meta information: text-xs (12px) - timestamps, IDs, counts
- Data labels: text-xs font-medium uppercase tracking-wide

## Layout System

**Spacing Primitives:** Use Tailwind units of **2, 4, 6, 8, 12, 16** for consistency
- Component padding: p-4 to p-6
- Section spacing: mb-6 to mb-8
- Card gaps: gap-4
- Form field spacing: space-y-4

**Container Structure:**
- Full-width sidebar navigation (64px collapsed, 256px expanded)
- Main content area: max-w-7xl mx-auto px-6 py-8
- Two-column detail view: 2/3 for ticket details, 1/3 for metadata sidebar

## Component Library

### Navigation
- **Sidebar:** Vertical navigation with icons (Heroicons via CDN)
  - Dashboard, All Requests, Statistics, Settings sections
  - Active state indicator (left border accent + background)
  - Collapsible with icon-only mode
- **Top bar:** User info, notifications, logout (right-aligned)

### Data Display

**Requests Table:**
- Sticky header row
- Columns: Status badge, User (avatar + name), Subject preview, Timestamp, Media indicator, Actions
- Row hover state for scanability
- Checkbox column (leftmost) for bulk selection
- Status badges: Small rounded pills with distinct treatments
- Compact row height (h-12) for density

**User Card (Detail View):**
- Header section: User avatar (large), name, Telegram username, ID
- Tabbed interface: "Current Request" | "Full History" | "User Info"
- Timeline layout for message history (chat-like vertical flow)
- Message bubbles: User messages (left-aligned), Admin replies (right-aligned with distinct treatment)
- Media thumbnails inline with messages (clickable for full view)

**Statistics Dashboard:**
- Grid layout: grid-cols-1 md:grid-cols-2 lg:grid-cols-4
- Stat cards: Large number (text-3xl font-bold), label below, icon top-right
- Trend indicators (up/down arrows) where applicable

### Forms & Inputs

**Reply Form:**
- Textarea: min-h-32, resize-y, clear focus states
- Character counter below textarea (text-xs)
- Action buttons (primary "Send Reply", secondary "Save Draft")
- Attachment button for adding media references

**Bulk Reply Modal:**
- Overlay modal (backdrop blur)
- Selected count indicator at top
- Preview of selected users (scrollable list, max-h-48)
- Large textarea for message
- Confirmation required before sending

**Filters:**
- Horizontal filter bar above table
- Dropdown selects for Status (All, New, In Progress, Solved)
- Search input for user search (icon-left)
- Date range picker (optional quick filters: Today, Last 7 days, Last 30 days)

### Interactive Elements

**Buttons:**
- Primary actions: px-4 py-2, font-medium
- Icon buttons: p-2, square aspect
- Button groups for related actions (joined borders)

**Badges:**
- Status indicators: px-2 py-1, text-xs font-medium, rounded-full
- Count badges: Circular for numbers (notifications, media count)

**Cards:**
- Elevated cards: shadow-sm border rounded-lg
- Section padding: p-6
- Dividers between sections within cards

### Data States

**Empty States:**
- Centered icon + message + action button
- Use when no requests match filters or no history exists

**Loading States:**
- Skeleton loaders for table rows (animate-pulse)
- Spinner for form submissions

**Media Display:**
- Thumbnail grid (grid-cols-3 gap-2) for multiple attachments
- Lightbox modal for full-size viewing
- Video indicators (play icon overlay)

## Responsive Behavior

**Desktop (lg+):** 
- Expanded sidebar + full table + multi-column stats
- Split view for detail pages

**Tablet (md):**
- Collapsed sidebar (icon-only)
- Full table with horizontal scroll if needed
- 2-column stats grid

**Mobile (base):**
- Bottom navigation bar replaces sidebar
- Vertical card list replaces table
- Stack all detail view sections
- Full-width forms

## Icons
Use **Heroicons** (outline variant) via CDN for consistent iconography:
- Navigation icons, status indicators, actions, media types