#!/bin/bash

# ===========================================
# Установка для Node.js 16+ (без сборки)
# ===========================================

set -e

echo "=========================================="
echo "  Установка панели поддержки MovieLab"
echo "  (для Node.js 16+)"
echo "=========================================="

# Проверка Node.js
echo "[1/4] Проверка Node.js..."
node -v

# Проверка PM2
if ! command -v pm2 &> /dev/null; then
    echo "[2/4] Установка PM2..."
    sudo npm install -g pm2
else
    echo "[2/4] PM2 уже установлен"
fi

# Создание .env файла
echo "[3/4] Создание конфигурации..."

if [ -f .env ]; then
    echo "  Файл .env уже существует, пропускаем..."
else
    cat > .env << 'EOF'
NODE_ENV=production
PORT=5000

# MySQL
MYSQL_HOST=localhost
MYSQL_PORT=3306
MYSQL_USER=root
MYSQL_PASSWORD=dE5vbtjQ42Nf
MYSQL_DATABASE=movielab

# Telegram Bot
TELEGRAM_BOT_TOKEN=5946069569:AAFZF6pbQiGhVidsmJk-VH7YTtShtxuH_N8

# Безопасность
SESSION_SECRET=movielab-support-panel-secret-key-change-me
ADMIN_USERNAME=admin
ADMIN_PASSWORD=admin123
EOF
    echo "  Файл .env создан"
    echo ""
    echo "  !!! ВАЖНО: Измените ADMIN_PASSWORD в файле .env !!!"
    echo ""
fi

# Запуск через PM2
echo "[4/4] Запуск приложения..."

# Остановка если уже запущено
pm2 delete support-panel 2>/dev/null || true

# Запуск собранного файла напрямую через node
pm2 start dist/index.cjs --name "support-panel"

# Сохранение конфигурации PM2
pm2 save

echo ""
echo "=========================================="
echo "  Установка завершена!"
echo "=========================================="
echo ""
echo "Панель доступна по адресу: http://$(hostname -I | awk '{print $1}'):5000"
echo ""
echo "Учётные данные:"
echo "  Логин: admin"
echo "  Пароль: admin123 (ИЗМЕНИТЕ в .env!)"
echo ""
echo "Полезные команды:"
echo "  pm2 status              - статус приложения"
echo "  pm2 logs support-panel  - просмотр логов"
echo "  pm2 restart support-panel - перезапуск"
echo ""
