#!/bin/bash

# ===========================================
# Скрипт установки панели поддержки Telegram бота
# ===========================================

set -e

echo "=========================================="
echo "  Установка панели поддержки MovieLab"
echo "=========================================="

# Проверка Node.js
if ! command -v node &> /dev/null; then
    echo "[1/6] Установка Node.js 20..."
    curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -
    sudo apt-get install -y nodejs
else
    echo "[1/6] Node.js уже установлен: $(node -v)"
fi

# Проверка PM2
if ! command -v pm2 &> /dev/null; then
    echo "[2/6] Установка PM2..."
    sudo npm install -g pm2
else
    echo "[2/6] PM2 уже установлен"
fi

# Установка зависимостей
echo "[3/6] Установка зависимостей..."
npm install

# Создание .env файла
echo "[4/6] Создание конфигурации..."

if [ -f .env ]; then
    echo "  Файл .env уже существует, пропускаем..."
else
    cat > .env << 'EOF'
NODE_ENV=production
PORT=5000

# MySQL
MYSQL_HOST=localhost
MYSQL_PORT=3306
MYSQL_USER=root
MYSQL_PASSWORD=dE5vbtjQ42Nf
MYSQL_DATABASE=movielab

# Telegram Bot
TELEGRAM_BOT_TOKEN=5946069569:AAFZF6pbQiGhVidsmJk-VH7YTtShtxuH_N8

# Безопасность
SESSION_SECRET=movielab-support-panel-secret-$(date +%s)
ADMIN_USERNAME=admin
ADMIN_PASSWORD=admin123
EOF
    echo "  Файл .env создан"
    echo ""
    echo "  !!! ВАЖНО: Измените ADMIN_PASSWORD в файле .env !!!"
    echo ""
fi

# Сборка проекта
echo "[5/6] Сборка проекта..."
npm run build

# Запуск через PM2
echo "[6/6] Запуск приложения..."

# Остановка если уже запущено
pm2 delete support-panel 2>/dev/null || true

# Запуск
pm2 start npm --name "support-panel" -- start

# Сохранение конфигурации PM2
pm2 save

# Настройка автозапуска
echo ""
echo "Настройка автозапуска при перезагрузке сервера..."
pm2 startup | tail -1 | bash 2>/dev/null || echo "  (выполните команду pm2 startup вручную если нужно)"

echo ""
echo "=========================================="
echo "  Установка завершена!"
echo "=========================================="
echo ""
echo "Панель доступна по адресу: http://$(hostname -I | awk '{print $1}'):5000"
echo ""
echo "Учётные данные:"
echo "  Логин: admin"
echo "  Пароль: admin123 (ИЗМЕНИТЕ в .env!)"
echo ""
echo "Полезные команды:"
echo "  pm2 status          - статус приложения"
echo "  pm2 logs support-panel - просмотр логов"
echo "  pm2 restart support-panel - перезапуск"
echo ""
