# Telegram Bot Support Panel

Веб-панель для управления обращениями пользователей Telegram бота.

## Обзор

Это приложение предоставляет веб-интерфейс для просмотра и ответа на обращения пользователей, отправленные через Telegram бота. Администраторы могут:

- Просматривать все обращения с фильтрацией по статусу
- Просматривать детальную карточку пользователя с историей обращений
- Отвечать на обращения (сообщения отправляются в Telegram)
- Отправлять массовые ответы нескольким пользователям одновременно
- Просматривать медиафайлы из обращений

## Архитектура проекта

```
├── client/                  # React фронтенд
│   ├── src/
│   │   ├── components/     # UI компоненты
│   │   │   ├── app-sidebar.tsx
│   │   │   ├── bulk-reply-dialog.tsx
│   │   │   ├── media-gallery.tsx
│   │   │   ├── message-timeline.tsx
│   │   │   ├── reply-form.tsx
│   │   │   ├── request-table.tsx
│   │   │   ├── stats-card.tsx
│   │   │   ├── status-filter.tsx
│   │   │   ├── theme-toggle.tsx
│   │   │   └── ui/         # Shadcn компоненты
│   │   ├── pages/
│   │   │   ├── dashboard.tsx
│   │   │   ├── login.tsx
│   │   │   ├── request-detail.tsx
│   │   │   └── requests.tsx
│   │   ├── lib/
│   │   │   ├── queryClient.ts
│   │   │   ├── theme-provider.tsx
│   │   │   └── utils.ts
│   │   └── App.tsx
├── server/                  # Express бекенд
│   ├── db.ts               # MySQL подключение
│   ├── telegram.ts         # Telegram Bot API
│   ├── storage.ts          # Слой данных
│   ├── routes.ts           # API эндпоинты
│   └── index.ts
└── shared/
    └── schema.ts           # Общие типы данных
```

## Технологии

- **Frontend**: React, TypeScript, Tailwind CSS, Shadcn UI
- **Backend**: Express.js, Node.js
- **Database**: MySQL (подключение к существующей БД бота)
- **Telegram**: node-telegram-bot-api

## Переменные окружения

Требуемые секреты:
- `TELEGRAM_BOT_TOKEN` - Токен Telegram бота
- `MYSQL_HOST` - Хост MySQL сервера
- `MYSQL_PORT` - Порт MySQL (по умолчанию 3306)
- `MYSQL_USER` - Имя пользователя MySQL
- `MYSQL_PASSWORD` - Пароль MySQL
- `MYSQL_DATABASE` - Название базы данных
- `SESSION_SECRET` - Секрет для сессий (уже настроен)

Опциональные:
- `ADMIN_USERNAME` - Имя администратора (по умолчанию: admin)
- `ADMIN_PASSWORD` - Пароль администратора (по умолчанию: admin123)

## API Эндпоинты

### Аутентификация
- `POST /api/auth/login` - Вход в систему
- `GET /api/auth/me` - Проверка текущей сессии
- `POST /api/auth/logout` - Выход

### Обращения
- `GET /api/requests` - Список всех обращений
- `GET /api/requests/:id` - Детали обращения
- `GET /api/requests/:id/messages` - История сообщений
- `POST /api/requests/:id/reply` - Ответ на обращение
- `PATCH /api/requests/:id/status` - Изменение статуса
- `POST /api/requests/bulk-reply` - Массовый ответ

### Пользователи
- `GET /api/users/:userId/requests` - Обращения пользователя

### Статистика
- `GET /api/stats` - Статистика обращений

## Запуск

```bash
npm run dev
```

Приложение будет доступно на порту 5000.

## Учётные данные по умолчанию

- Логин: `admin`
- Пароль: `admin123`

**Важно**: Измените эти данные в production!
