import { z } from "zod";

export const requestStatusEnum = ["new", "in_progress", "resolved"] as const;
export type RequestStatus = (typeof requestStatusEnum)[number];

export interface TelegramUser {
  id: number;
  firstName: string;
  lastName: string;
  username: string;
}

export interface SupportRequest {
  id: number;
  odID: number;
  odFirstName: string;
  odLastName: string;
  odUsername: string;
  text: string;
  media: string | null;
  status: RequestStatus;
  timestamp: number;
  takenBy: number | null;
}

export interface SupportMessage {
  id: number;
  odID: number;
  odFirstName: string;
  odLastName: string;
  odUsername: string;
  text: string;
  isAdmin: boolean;
  timestamp: number;
  requestId: number | null;
}

export interface DashboardStats {
  totalRequests: number;
  newRequests: number;
  inProgressRequests: number;
  resolvedRequests: number;
  activeUsers: number;
}

export const loginSchema = z.object({
  username: z.string().min(1, "Введите имя пользователя"),
  password: z.string().min(1, "Введите пароль"),
});

export type LoginInput = z.infer<typeof loginSchema>;

export const replySchema = z.object({
  message: z.string().min(1, "Введите сообщение"),
});

export type ReplyInput = z.infer<typeof replySchema>;

export const bulkReplySchema = z.object({
  message: z.string().min(1, "Введите сообщение"),
  requestIds: z.array(z.number()).min(1, "Выберите хотя бы одно обращение"),
});

export type BulkReplyInput = z.infer<typeof bulkReplySchema>;

export interface AdminUser {
  id: string;
  username: string;
}

export interface User {
  id: string;
  username: string;
  password: string;
}

export type InsertUser = Omit<User, "id">;
